
wspDefault equ 83C0h
wspMonitor equ 83E0h
			
userRam    equ 8300h
CursorX    equ userRam+20h

VDPWD   EQU     8C00h           ;VDP RAM write data
VDPWA   EQU     8C02h           ;VDP RAM read/write address

	include "\srcAll\v1_Header.asm"

	bl @ScrInit
	
	li r0,TestData
	li r1,UserRam
	li r2,5
	bl @LDIR			;Copy 10 test bytes to 8300h
	
	li r0,0
	mov r0,r1
	mov r0,r2
	mov r0,r3
	
	blwp @ShowRam		;Show 8300h test data
	blwp @Monitor4		;Monitor Dump
	
	;jmp AddressTests1
	;jmp AddressTests2
	jmp AddressTests3
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

AddressTests1:	
;Immediate Addressing
	li r0,UserRam		;load 'Userram' (8300h) into r0
	li r1,0FFEEh		;Hex must start with a 0
	blwp @Monitor4		;Monitor Dump
	
;Workspace Regsiter Addressing
	mov r0,r2			;Move value in R0 into R2
	mov r1,r3			;Move value in R1 into R3
	blwp @Monitor4		;Monitor Dump

;Workspace Regsister Indirect Addressing
	mov *r0,r3			;Set R3 from address in R0
	mov *r1,r2			;Set R2 from address in R1
	blwp @Monitor4		;Monitor Dump
	
	
InfLoop2:
	jmp InfLoop2        	;Branch to Infloop	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AddressTests2:
	li r0,UserRam		;load 'Userram' (8300h) into r0
	
;Workspace Regsister Indirect Auto Increment Addressing
	mov *r0+,r1			;Set R1 from address in R0...inc RO
	blwp @Monitor4		;Monitor Dump
	mov *r0+,r2			;Set R1 from address in R0...inc RO
	blwp @Monitor4		;Monitor Dump
	mov *r0+,r3			;Set R1 from address in R0...inc RO
	blwp @Monitor4		;Monitor Dump

	blwp @DoNewLineW
	
	mov @UserRam,r0
	mov @UserRam+2,r1
	mov @UserRam+4,r2
	mov @UserRam+6,r3
	blwp @Monitor4		;Monitor Dump
	
	mov @UserRam,r0
	mov @UserRam+1,r1
	mov @UserRam+2,r2
	mov @UserRam+3,r3
	blwp @Monitor4		;Monitor Dump
	
	jmp InfLoop        	;Branch to Infloop	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

AddressTests3:
	
;Indexed Addressing

off2 equ 2000

	li r0,TestDataLookup
;	mov @(r0),r1			;Load R1 from UserRam+0
	mov *(r0,r1)		;Load R1 from UserRam+0
	mov @off2(r0),r2		;Load R1 from UserRam+0
	;mov 4*r0,r3		;Load R1 from UserRam+0
	blwp @Monitor4		;Monitor Dump
	
	li r0,TestData
;	mov @(r0),r1			;Load R1 from UserRam+0
	;mov @(r0+2),r2		;Load R1 from UserRam+0
	;mov @(r0+4),r3		;Load R1 from UserRam+2
	blwp @Monitor4		;Monitor Dump	
	
	jmp InfLoop        	;Branch to Infloop	
	
;Program Counter Relative Addressing
;CRU Relative Addressing (R12)

	
	
	jmp InfLoop        	;Branch to Infloop	
	
	
	
	
	
	jmp MoveLoad
	jmp AddSub
	jmp IncDec
	
TestData:
	byte 11h,22h,33h,44h,55h,66h,77h,88h,99h,0AAh

TestDataLookup:	
	word TestData1
	word TestData2
	word TestData3
	
TestData1:
	byte 11h,12h,13h,14h
TestData2:
	byte 21h,22h,23h,24h
TestData3:
	byte 31h,32h,33h,34h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MoveLoad:
	li r0,01234h		;1234h->R0
	blwp @Monitor4		;Monitor Dump
	
	mov r0,r1			;R0->R1
	mov r0,r2			;R0->R2
	mov r0,r3			;R0->R3
	
	blwp @Monitor4		;Monitor Dump
	
	blwp @DoNewLineW
	
	clr r0
	seto r1
	
	blwp @Monitor4		;Monitor Dump
	
	jmp InfLoop        	;Branch to Infloop	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
AddSub:

	blwp @Monitor4		;Monitor Dump
	
	ai r2,4				;R2=R2+4
	ai r3,-4			;R3=R3-4
	blwp @Monitor4		;Monitor Dump
	
	li r1,10h
	
	a r1,r2				;R2=R2+R1
	s r1,r3				;R3=R3+R1
	
	blwp @Monitor4		;Monitor Dump
	blwp @DoNewLineW
	
	li r0,01234h		;1234h->R0
	li r1,01234h		;1234h->R0
	li r2,01234h		;1234h->R0
	li r3,01234h		;1234h->R0
	blwp @Monitor4		;Monitor Dump
	jmp InfLoop        	;Branch to Infloop	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
IncDec:	
	inc  r0				;Add 1 to R0
	inct r1				;Add 2 to R1
	dec  r2				;Subtract 1 from R2
	dect r3				;Subtract 2 from R3
	blwp @Monitor4		;Monitor Dump
	inc  r0				;Add 1 to R0
	inct r1				;Add 2 to R1
	dec  r2				;Subtract 1 from R2
	dect r3				;Subtract 2 from R3
	blwp @Monitor4		;Monitor Dump
	inc  r0				;Add 1 to R0
	inct r1				;Add 2 to R1
	dec  r2				;Subtract 1 from R2
	dect r3				;Subtract 2 from R3
	blwp @Monitor4		;Monitor Dump
	inc  r0				;Add 1 to R0
	inct r1				;Add 2 to R1
	dec  r2				;Subtract 1 from R2
	dect r3				;Subtract 2 from R3
	blwp @Monitor4		;Monitor Dump
	jmp InfLoop        	;Branch to Infloop	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
InfLoop:
	jmp InfLoop        	;Branch to Infloop

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LDIR:
		mov *r0+,*r1+		;copy from (R1) to (R0)
		dec r2
		jne LDIR
		B *R11				;Return
ShowRam:
	word wspMonitor
	word Doramdump
	
Doramdump:	
		li r4,userRam		;address to show
		li r5,00005h		;words to show
		bl @ramdump			;Dump Memory
		bl @NewLine
		bl @NewLine
	RTWP
Monitor4:
	word wspMonitor
	word DoMonitor4
	
DoMonitor4:
		mov r13,r5
		li r6,0000h
DoMonitorAgain4:		
		mov *r5+,r2
		mov r6,r1
		bl @ShowReg
		ai r6,0100h
		ci r6,0400h 
		jne DoMonitorAgain4
		
		bl @NewLine
	RTWP
	
DoNewLineW:
	word wspMonitor
	word DoNewLine
	
DoNewLine:
		bl @NewLine
	RTWP
		
PrintString:
		mov r11,r10			;Move Return to R10
PrintStringAgain:
        MOVB *R1+,R0
		 
		li r2,255
		Cb r0,r2
		jeq PrintStringDone
		bl @PrintChar
        Jmp PrintStringAgain
PrintStringDone:
		B *R10				;Return		
		
	include "\SrcAll\monitor.asm"
	include "\SrcAll\functions.asm"



	
HELLOWORLD
    BYTE "HELLo WoRLD!123:@"     ;* string data
    BYTE 255
;    END