
wspDefault equ 83C0h
wspMonitor equ 83E0h
			
userRam    equ 8300h
CursorX    equ userRam+20h

VDPWD   EQU     8C00h           ;VDP RAM write data
VDPWA   EQU     8C02h           ;VDP RAM read/write address

	include "\srcAll\v1_Header.asm"

	bl @ScrInit
	
	;jmp TestAndOrSocSzc	
	;jmp TestCocCzc
	;jmp TestBitOps
	jmp TestBitShifts

TestBitShifts:
	li r0,850Dh
	li r1,16
	blwp @MonitorBitsR0
	blwp @DoNewLineW
	
TestBitShiftsA:	
	;src r0,1		;ROR
	;srl r0,1		;Shift Right Logical
	sra r0,1		;Shift Right Arithmatic
	;sla r0,1
	blwp @MonitorBitsR0
	dec r1
	jne TestBitShiftsA
	
	jmp InfLoop        	;Branch to Infloop
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
TestBitOps:
	li  r0,1234h
	mov r0,r1
	mov r0,r2
	li r3,00FFh
	blwp @Monitor4
	
	inv r0
	neg r1
	xor r3,r2
	blwp @Monitor4
	
	abs r0
	abs r1
	abs r2
	abs r3
	blwp @Monitor4
	
	blwp @DoNewLineW

	
	jmp InfLoop        	;Branch to Infloop
	
TestAndOrSocSzc:
	li  r0,1234h
	mov r0,r1
	mov r0,r2
	mov r0,r3
	li  r5,0FFFh
	
	
	blwp @Monitor4
	andi r0,0FFFh
	ori r1,0FFFh
	
	soc r5,r2		;OR
	szc r5,r3		;Reverse AND
	
	blwp @Monitor4
	blwp @DoNewLineW
	
	li  r0,1234h
	mov r0,r1
	mov r0,r2
	mov r0,r3
	li  r5,0FF0h
	
	blwp @Monitor4
	
	socb r5,r2		;OR
	szcb r5,r3		;Reverse AND
	
	blwp @Monitor4
	jmp InfLoop        	;Branch to Infloop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
TestCocCzc:
	
	li r0,00FFFh
;Test Dest to determine if 1 bits are 1 in Source... If so Zero flag set
	li r1,00FFFh
	coc r0,r1			;is 
	blwp @MonitorFlagsR0R1
	
	li r1,0F0FFh
	coc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,0FF0Fh
	coc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,000FFh
	coc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,000FFh
	coc r1,r0
	blwp @MonitorFlagsR0R1
	
	blwp @DoNewLineW
	
;Test Dest to determine if O bits are 0 in Source... If so Zero flag set
	li r0,00FFFh
	
	li r1,0F000h
	czc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,00F00h
	czc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,000F0h
	czc r0,r1
	blwp @MonitorFlagsR0R1
	
	li r1,0FF00h
	czc r0,r1
	blwp @MonitorFlagsR0R1

	
	li r1,0FF00h
	czc r1,r0
	blwp @MonitorFlagsR0R1
	
	jmp InfLoop        	;Branch to Infloop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
InfLoop:
	jmp InfLoop        	;Branch to Infloop

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LDIR:
		mov *r0+,*r1+		;copy from (R1) to (R0)
		dec r2
		jne LDIR
		B *R11				;Return
ShowRam:
	word wspMonitor
	word Doramdump
	
Doramdump:	
		li r4,userRam		;address to show
		li r5,00005h		;words to show
		bl @ramdump			;Dump Memory
		bl @NewLine
		bl @NewLine
	RTWP
	
MonitorFlags:	
	word wspMonitor
	word DoMonitorFlags
	
DoMonitorFlags:	
		stst r4
		li r3,FlagChars
		li r1,16
FlagAgain:
		movb *r3+,r0
		sla r4,1
		joc FlagOn
		li r0,'. '
FlagOn:
		bl @PrintChar
		
		dec r1
		jne FlagAgain
		bl @NewLine
		bl @NewLine
	RTWP

MonitorBitsR0:	
	word wspMonitor
	word DoMonitorBitsR0
	
DoMonitorBitsR0:	
	li r1,0000h
	mov *r13,r2
	bl @ShowReg
	
	li r0,'-C'
	mov r15,r2
	andi r2,1000h
	jeq DoMonitorBitsR0NC
	swpb r0
DoMonitorBitsR0NC:		
	bl @PrintChar

	li r0,'  '
	bl @PrintChar
	
	mov *r13,r4
	li r1,16
DoMonitorBitsR0AgainB:
	li r0,'10'
	sla r4,1
	joc DoMonitorBitsR0OnB
	swpb r0
DoMonitorBitsR0OnB:
	bl @PrintChar
	
	dec r1
	jne DoMonitorBitsR0AgainB
		
	li r0,'  '
	bl @PrintChar
	
	bl @NewLine
	RTWP
	
MonitorFlagsR0R1:	
	word wspMonitor
	word DoMonitorFlagsR0R1
		
	
DoMonitorFlagsR0R1:	
		stst r4
		mov r13,r5
		li r6,0000h
DoMonitorAgain2:		
		mov *r5+,r2
		mov r6,r1
		bl @ShowReg
		ai r6,0100h
		ci r6,0200h 
		jne DoMonitorAgain2
		
		li r3,FlagChars
		li r1,16
FlagAgainB:
		movb *r3+,r0
		sla r4,1
		joc FlagOnB
		li r0,'. '
FlagOnB:
		bl @PrintChar
		
		dec r1
		jne FlagAgainB
		bl @NewLine
	RTWP

	
FlagChars:	
	byte 'L','A','=','C','V','P','X','!',  'I','I','I','I','!','!','!','!'
Monitor4:
	word wspMonitor
	word DoMonitor4
	
DoMonitor4:
		mov r13,r5
		li r6,0000h
DoMonitorAgain4:		
		mov *r5+,r2
		mov r6,r1
		bl @ShowReg
		ai r6,0100h
		ci r6,0400h 
		jne DoMonitorAgain4
		
		bl @NewLine
	RTWP
 

	
DoNewLineW:
	word wspMonitor
	word DoNewLine
	
DoNewLine:
		bl @NewLine
	RTWP
		

	include "\SrcAll\monitor.asm"
	include "\SrcAll\functions.asm"


